/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.single;

import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Single;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.SingleObserver;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.SingleSource;
import dev.compactmods.crafting.lib.reactivex.rxjava3.disposables.CompositeDisposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.disposables.Disposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.exceptions.Exceptions;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;

public final class SingleAmb<T>
extends Single<T> {
    private final SingleSource<? extends T>[] sources;
    private final Iterable<? extends SingleSource<? extends T>> sourcesIterable;

    public SingleAmb(SingleSource<? extends T>[] sources, Iterable<? extends SingleSource<? extends T>> sourcesIterable) {
        this.sources = sources;
        this.sourcesIterable = sourcesIterable;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> observer) {
        SingleSource<? extends T>[] sources = this.sources;
        int count = 0;
        if (sources == null) {
            sources = new SingleSource[8];
            try {
                for (SingleSource<? extends T> singleSource : this.sourcesIterable) {
                    if (singleSource == null) {
                        EmptyDisposable.error((Throwable)new NullPointerException("One of the sources is null"), observer);
                        return;
                    }
                    if (count == sources.length) {
                        SingleSource[] b = new SingleSource[count + (count >> 2)];
                        System.arraycopy(sources, 0, b, 0, count);
                        sources = b;
                    }
                    sources[count++] = singleSource;
                }
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                EmptyDisposable.error(e, observer);
                return;
            }
        } else {
            count = sources.length;
        }
        AtomicBoolean winner = new AtomicBoolean();
        CompositeDisposable compositeDisposable = new CompositeDisposable();
        observer.onSubscribe(compositeDisposable);
        for (int i = 0; i < count; ++i) {
            SingleSource<T> s1 = sources[i];
            if (compositeDisposable.isDisposed()) {
                return;
            }
            if (s1 == null) {
                compositeDisposable.dispose();
                NullPointerException e = new NullPointerException("One of the sources is null");
                if (winner.compareAndSet(false, true)) {
                    observer.onError(e);
                } else {
                    RxJavaPlugins.onError(e);
                }
                return;
            }
            s1.subscribe(new AmbSingleObserver<T>(observer, compositeDisposable, winner));
        }
    }

    static final class AmbSingleObserver<T>
    implements SingleObserver<T> {
        final CompositeDisposable set;
        final SingleObserver<? super T> downstream;
        final AtomicBoolean winner;
        Disposable upstream;

        AmbSingleObserver(SingleObserver<? super T> observer, CompositeDisposable set, AtomicBoolean winner) {
            this.downstream = observer;
            this.set = set;
            this.winner = winner;
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.upstream = d;
            this.set.add(d);
        }

        @Override
        public void onSuccess(T value) {
            if (this.winner.compareAndSet(false, true)) {
                this.set.delete(this.upstream);
                this.set.dispose();
                this.downstream.onSuccess(value);
            }
        }

        @Override
        public void onError(Throwable e) {
            if (this.winner.compareAndSet(false, true)) {
                this.set.delete(this.upstream);
                this.set.dispose();
                this.downstream.onError(e);
            } else {
                RxJavaPlugins.onError(e);
            }
        }
    }
}

